---
category: reference
heading: "apply_patch(document, patch)"
---

A shortcut to apply a patch given as an Array or as a JSON String (see the [JSONPatch RFC 6902][#jsonpatch] for the patch format) to a document. Will not mutate the original document, however the new document may share some structure with the original.


* document - The document to operate against. May be mutated.
* patch - The patch document as a JS Array of operations or as a JSON String representing the same (the latter requires JSON support in your browser or the inclusion of the JSON2 library or similar)

Example:

    mydoc = {
      "baz": "qux",
      "foo": "bar"
    };
    thepatch = [
      { "op": "replace", "path": "/baz", "value": "boo" }
    ]
    patcheddoc = jsonpatch.apply_patch(mydoc, thepatch);
    // patcheddoc now equals {"baz": "boo", "foo": "bar"}}


[#jsonpatch]: http://tools.ietf.org/html/rfc6902

Throws:

* InvalidPatch if the patch is invalid
* PatchApplyError if the patch could not apply against the given document
